extern float4x4	g_WorldProj :	register(c0);
extern float4x4	g_World :		register(c4);



struct VS_OUTPUT
{
	float4	m_Position :	POSITION;
	float3	m_World :		TEXCOORD0;
	float3	m_Normal:		TEXCOORD1;
};



struct VS_INPUT
{
 	float4	m_Position :	POSITION;
	float3	m_Normal :		NORMAL;
};




/*
 * Particles vertex shader
 */
VS_OUTPUT MainVS(VS_INPUT input)
{
 	VS_OUTPUT output	=	(VS_OUTPUT) 0;

	output.m_Position	=	mul(input.m_Position, g_WorldProj);
	output.m_World		=	mul(input.m_Position, g_World);
	output.m_Normal		=	mul(input.m_Normal, (float3x3) g_World);

	return output;
}